/**
 * \file: mspin_demo_iap2_connection.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * mySPIN iAP2 Connection
 *
 * \component: MSPIN
 *
 * \author: Bui Le Thuan / thuan.buile@vn.bosch.com
 *          Thilo Fickel ICT-ADITG/SW2 tfickel@de.adit-jv.com
 *
 * \copyright: (c) 2003 - 2013 ADIT Corporation
 *
 * \history
 * 0.1 TFickel Initial version
 *
 ***********************************************************************/

#ifndef IAP2_TSET_CONFIGURATION_PFCGF
#define IAP2_TSET_CONFIGURATION_PFCGF

#include "adit_typedef.h"

#define IAP2_AUTH_CONFIGURATION_FILE        "IPOD_AUTH"
#define IAP2_CFG_STR_MAX                    256
#define IAP2_CFG_NUM_LENGTH                 1
#define IAP2_ERR_ABORT                      -1

#define IPOD_AUTH_DEV_NAME                  "IPOD_AUTH_DEV_NAME"
#define IPOD_AUTH_IOCTL_REG                 "IPOD_AUTH_IOCTL_REG"
#define IPOD_AUTH_GPIO_RESET                "IPOD_AUTH_GPIO_RESET"
#define IPOD_AUTH_GPIO_READY                "IPOD_AUTH_GPIO_READY"
#define IPOD_AUTH_DEV_COM_SHORT_WAIT        "IPOD_AUTH_DEV_COM_SHORT_WAIT"
#define IPOD_AUTH_DEV_COM_WAIT              "IPOD_AUTH_DEV_COM_WAIT"
#define IPOD_AUTH_DEV_COM_LONG_WAIT         "IPOD_AUTH_DEV_COM_LONG_WAIT"

typedef struct _IAP2TEST_Cfg
{
    U8 *name;
    U8 isInt;
    union
    {
        S32 val;
        U8* p_val;
    }para;
} IAP2TEST_Cfg;

typedef enum
{
   IAP2_DC_AUTH_DEV_NAME,
   IAP2_DC_AUTH_IOCTL_REG,
   IAP2_DC_AUTH_RESET,
   IAP2_DC_AUTH_READY,
   IAP2_DC_AUTH_SHORT_WAIT,
   IAP2_DC_AUTH_WAIT,
   IAP2_DC_AUTH_LONG_WAIT,

}IAP2_DC_TYPE;

class Iap2ConfigurationPfcfg
{
private:
    /***************************************************************************//**
    * Get Number from Devconf parameter
    *
    * \param[in] IAP2TEST_Cfg_FileName .cfg file name to read
    * \param[in] i key identifier
    * \param[in] iAP2TestCfg pointer to structure holding the values
    *            read from config file
    * \return A signed integer value indicating success or failure
    *
    * \see
    * \note
    ******************************************************************************/
    S32 iAP2TestGetDevConfNumParam(VP IAP2TEST_Cfg_FileName, U32 i, IAP2TEST_Cfg* iAP2TestCfg);

    /***************************************************************************//**
    * Get String from Devconf parameter
    *
    * \param[in] IAP2TEST_Cfg_FileName .cfg file name to read
    * \param[in] i key identifier
    * \param[in] iAP2TestCfg pointer to structure holding the values
    *            read from config file
    * \return A signed integer value indicating success or failure
    *
    * \see
    * \note
    ******************************************************************************/
    S32 iAP2TestGetDevConfStrParam(VP IAP2TEST_Cfg_FileName, U32 i, IAP2TEST_Cfg* iAP2TestCfg);

    /***************************************************************************//**
    * Reads numeric value from the device configuration.
    *
    * \param[in] IAP2TEST_Cfg_FileName .cfg file name to read
    * \param[in] *identifier identifier for the address to read
    * \param[in] *int_value read integer value (0 in case of error)
    * \return A signed integer value indicating success or failure
    *
    * \see
    * \note
    ******************************************************************************/
    S32 iAP2Test_util_bGetCfn(VP IAP2TEST_Cfg_FileName, S8  *identifier,
                                       S32 * int_value);

    /***************************************************************************//**
    * Reads string value from the device configuration
    *
    * \param[in] IAP2TEST_Cfg_FileName .cfg file name to read
    * \param[in] *identifier identifier for the address to read
    * \param[in] *str_value read string value (0 in case of error)
    * \param[in]  size size of the string needs to copied
    * \return A signed integer value indicating success or failure
    *
    * \see
    * \note
    ******************************************************************************/
    S32 iAP2Test_util_bGetCfs(VP IAP2TEST_Cfg_FileName, S8  *identifier,
                                       char* str_value,
                                       U32 size);

public:

    /***************************************************************************//**
    * Read the configuration values from the PFCFG file and store the settings
    * into IAP2TEST_Cfg g_iAP2TestCfg[]
    *
    * \param[out] *num_cfg Pointer to hold the no. of config entries in the config file.
    * \return Pointer to structure holding the values read from config file.
    *
    * \see
    * \note
    ******************************************************************************/
    IAP2TEST_Cfg * iAP2TestGetDevconfParameter(U8* num_cfg);

    /***************************************************************************//**
    * Free the configuration values stored in IAP2TEST_Cfg g_iAP2TestCfg[]
    *
    * \param[in] Pointer to structure holding the values read from config file
    * \param[in] num_cfg no. of keys in the config file
    * \return None
    *
    * \see
    * \note
    ******************************************************************************/
    void iAP2TestFreeDevconfParameter(IAP2TEST_Cfg * p_iAP2TestCfg, U8 num_cfg);
};

#endif    /* IAP2_TEST_CONFIGURATION_PFCFG */

